# 文艺爱好者专属导航平台 - 目录结构

## 项目根目录

```
a1687/
├── css/                # CSS 样式文件目录
│   └── style.css       # 主样式文件，包含所有页面样式
├── doc/                # 文档目录
│   ├── projIntro.md    # 项目详细介绍
│   ├── techFeat.md     # 技术特点
│   ├── dirStru.md      # 目录结构
│   └── userInstr.md    # 使用说明
├── img/                # 图片资源目录（全部为 SVG 格式）
│   ├── logo.svg        # 网站 LOGO
│   ├── search.svg      # 搜索图标
│   ├── background-pattern.svg  # 背景图案
│   ├── literature.svg  # 文学分类图标
│   ├── art.svg         # 艺术分类图标
│   ├── music.svg       # 音乐分类图标
│   ├── film.svg        # 电影分类图标
│   ├── design.svg      # 设计分类图标
│   ├── photography.svg # 摄影分类图标
│   ├── website1.svg    # 网站图标 1
│   ├── website2.svg    # 网站图标 2
│   ├── website3.svg    # 网站图标 3
│   ├── website4.svg    # 网站图标 4
│   ├── website5.svg    # 网站图标 5
│   ├── website6.svg    # 网站图标 6
│   ├── featured1.svg   # 精选内容图片 1
│   └── featured2.svg   # 精选内容图片 2
├── js/                 # JavaScript 文件目录
│   └── main.js         # 主脚本文件，包含所有页面交互逻辑
├── index.html          # 首页
├── category.html       # 分类导航页
├── recommend.html      # 精选推荐页
└── about.html          # 关于我们页
```

## 目录说明

### 1. css/ 目录

- **style.css**：项目的主样式文件，包含所有页面的样式定义，采用现代化 CSS 特性，支持响应式设计。

### 2. doc/ 目录

- **projIntro.md**：项目详细介绍文档，包含项目概述、定位、功能模块、设计风格等内容。
- **techFeat.md**：技术特点文档，详细说明项目的技术栈、核心技术特点、技术亮点等。
- **dirStru.md**：目录结构文档，以树形结构呈现项目的文件组织，便于理解项目结构。
- **userInstr.md**：使用说明文档，包含环境要求、安装步骤、使用方法等内容。

### 3. img/ 目录

- **logo.svg**：网站的 LOGO 图片，采用 SVG 格式，包含书本、画笔、音符等文艺元素。
- **search.svg**：搜索图标，用于搜索框中的搜索按钮。
- **background-pattern.svg**：背景图案，用于搜索区域的背景装饰。
- **分类图标**：包含文学、艺术、音乐、电影、设计、摄影六个分类的图标。
- **网站图标**：用于展示推荐网站的图标，共 6 个。
- **精选内容图片**：用于精选内容区域的图片，共 2 个。

### 4. js/ 目录

- **main.js**：项目的主 JavaScript 文件，包含所有页面的交互逻辑，如移动端菜单、搜索功能、导航高亮、卡片交互等。

### 5. 根目录 HTML 文件

- **index.html**：网站的首页，包含网站 LOGO、导航菜单、搜索功能、热门分类、热门推荐、精选内容等模块。
- **category.html**：分类导航页，按文学、艺术、音乐、电影、设计、摄影等分类展示推荐网站。
- **recommend.html**：精选推荐页，展示精心挑选的优质文艺网站和内容。
- **about.html**：关于我们页，介绍网站的基本信息、特点、愿景等。

## 设计原则

1. **模块化设计**：将 CSS、JavaScript、图片资源分开存放，便于维护和扩展。
2. **响应式设计**：支持 PC 端和移动端适配，提供良好的跨设备体验。
3. **性能优化**：全部使用 SVG 格式图片，减少加载时间；代码精简，无冗余。
4. **可访问性**：采用语义化 HTML，确保良好的可访问性。
5. **代码规范**：遵循统一的命名规范和代码风格，提高代码的可读性和可维护性。

## 使用建议

1. **修改样式**：所有样式都在 `css/style.css` 文件中，可根据需要修改颜色、间距、字体等。
2. **添加内容**：
   - 添加新分类：在 `category.html` 中添加新的分类章节，并在 `index.html` 和 `recommend.html` 中添加对应的分类卡片。
   - 添加新网站：在对应的分类章节中添加网站卡片。
   - 添加新内容：在 `recommend.html` 中添加精选内容卡片。
3. **修改交互**：所有交互逻辑都在 `js/main.js` 文件中，可根据需要修改或添加新的交互功能。
4. **更新图片**：将新的 SVG 图片放入 `img/` 目录，并在 HTML 文件中引用。

通过清晰的目录结构和模块化的设计，项目具有良好的可维护性和可扩展性，便于后续的功能扩展和内容更新。