# 文艺爱好者专属导航平台 - 使用说明

## 1. 环境要求

### 1.1 浏览器要求

- **现代浏览器**：推荐使用 Chrome 90+、Firefox 88+、Safari 14+、Edge 90+ 等现代浏览器
- **兼容浏览器**：兼容 IE 11 及以上版本
- **移动端浏览器**：兼容主流移动端浏览器（如 Chrome Mobile、Safari Mobile 等）

### 1.2 硬件要求

- **CPU**：Intel Core i3 或 equivalent
- **内存**：4GB 及以上
- **存储空间**：至少 100MB 可用空间
- **网络连接**：建议使用宽带网络，确保资源加载流畅

### 1.3 软件要求

- 无需安装任何额外软件，直接通过浏览器访问
- 支持 Windows、macOS、Linux 等操作系统

## 2. 安装步骤

### 2.1 获取项目文件

1. **本地文件**：项目文件已存储在指定目录 `d:/vsqdc/prj1/code/a8/a1687` 中
2. **复制文件**：可以将整个 `a1687` 文件夹复制到本地任意位置

### 2.2 部署方式

#### 方式一：直接打开

1. 找到项目根目录下的 `index.html` 文件
2. 双击 `index.html` 文件，系统会自动使用默认浏览器打开
3. 即可开始使用网站

#### 方式二：本地服务器部署（推荐）

1. **安装本地服务器**：
   - 可以使用 Python 内置的 HTTP 服务器
   - 或使用 Node.js 的 http-server 模块
   - 或使用其他本地服务器工具

2. **使用 Python 内置服务器**：
   ```bash
   # 进入项目根目录
   cd d:/vsqdc/prj1/code/a8/a1687
   # 启动 HTTP 服务器（Python 3）
   python -m http.server 8000
   ```

3. **访问网站**：
   - 在浏览器地址栏输入 `http://localhost:8000`
   - 即可访问网站

#### 方式三：部署到远程服务器

1. 将整个 `a1687` 文件夹上传到远程服务器的 web 根目录
2. 通过服务器域名或 IP 地址访问网站

## 3. 使用方法

### 3.1 首页功能

1. **导航菜单**：
   - 点击顶部导航菜单可以跳转到不同页面
   - 首页：返回网站首页
   - 分类导航：查看分类网站列表
   - 精选推荐：查看精选网站和内容
   - 关于我们：了解网站信息

2. **搜索功能**：
   - 在搜索框中输入关键词
   - 点击搜索按钮或按下回车键进行搜索
   - 系统会模拟搜索结果

3. **热门分类**：
   - 点击分类卡片可以跳转到对应分类的详细页面
   - 每个分类卡片显示分类名称和描述

4. **热门推荐**：
   - 展示热门推荐的网站列表
   - 点击网站卡片可以跳转到对应的网站（模拟）
   - 每个网站卡片显示网站名称和描述

5. **精选内容**：
   - 展示精选的文章、展览等内容
   - 点击 "阅读全文" 或 "了解更多" 可以查看详细内容（模拟）

### 3.2 分类导航页

1. **分类列表**：
   - 页面按照文学、艺术、音乐、电影、设计、摄影等分类展示
   - 每个分类包含相关的网站推荐

2. **网站卡片**：
   - 点击网站卡片可以跳转到对应的网站（模拟）
   - 每个网站卡片显示网站图标、名称和描述

3. **快速导航**：
   - 可以通过页面顶部的导航菜单快速跳转到其他页面

### 3.3 精选推荐页

1. **精选网站**：
   - 展示精心挑选的优质文艺网站
   - 点击网站卡片可以跳转到对应的网站（模拟）

2. **精选内容**：
   - 展示精选的文章、展览、音乐、设计趋势等内容
   - 点击 "阅读全文" 或 "查看详情" 可以查看详细内容（模拟）

3. **热门分类**：
   - 展示热门分类卡片，便于快速导航

### 3.4 关于我们页

1. **平台介绍**：
   - 了解网站的定位、使命和愿景

2. **平台特点**：
   - 查看网站的核心特点和优势

3. **联系信息**：
   - 获取网站的联系信息和反馈渠道

### 3.5 移动端使用

1. **导航菜单**：
   - 点击右上角的汉堡菜单按钮
   - 展开移动端导航菜单
   - 点击菜单项跳转到对应页面

2. **响应式布局**：
   - 页面会根据设备屏幕尺寸自动调整布局
   - 在小屏幕设备上优化显示效果

## 4. 常见问题

### 4.1 页面显示异常

- **问题**：页面样式错乱或功能无法正常使用
- **解决方法**：
  1. 刷新页面，清除浏览器缓存
  2. 检查浏览器版本，确保使用推荐的现代浏览器
  3. 尝试使用其他浏览器访问
  4. 检查网络连接是否正常

### 4.2 图片无法显示

- **问题**：页面中的 SVG 图片无法显示
- **解决方法**：
  1. 检查图片文件是否存在于 `img/` 目录中
  2. 检查 HTML 文件中图片路径是否正确
  3. 刷新页面，清除浏览器缓存

### 4.3 搜索功能无效

- **问题**：搜索框输入关键词后无反应
- **解决方法**：
  1. 确保 JavaScript 功能正常启用
  2. 检查浏览器是否禁用了 JavaScript
  3. 刷新页面后重试

### 4.4 移动端菜单无法正常显示

- **问题**：点击汉堡菜单按钮后菜单无法显示或无法关闭
- **解决方法**：
  1. 刷新页面后重试
  2. 检查浏览器 JavaScript 功能是否正常
  3. 尝试使用其他移动端浏览器

## 5. 维护与更新

### 5.1 更新网站内容

1. **添加新分类**：
   - 在 `category.html` 中添加新的分类章节
   - 在 `index.html` 和 `recommend.html` 中添加对应的分类卡片

2. **添加新网站**：
   - 在 `category.html` 对应的分类章节中添加网站卡片
   - 在 `index.html` 或 `recommend.html` 中添加推荐网站

3. **更新精选内容**：
   - 在 `index.html` 和 `recommend.html` 中更新精选内容卡片

### 5.2 修改样式

- 所有样式都在 `css/style.css` 文件中
- 可以修改颜色、字体、间距、动画等样式参数
- 建议遵循现有的 CSS 命名规范

### 5.3 修改交互功能

- 所有交互逻辑都在 `js/main.js` 文件中
- 可以修改或添加新的交互功能
- 建议保持代码的模块化和可读性

## 6. 注意事项

1. **版权声明**：网站中的推荐网站链接仅作为导航使用，版权归原网站所有
2. **外部链接**：点击推荐网站链接会跳转到外部网站，请谨慎访问
3. **数据安全**：网站不会收集或存储用户个人信息，请放心使用
4. **更新频率**：建议定期更新网站内容，保持资源的新鲜度
5. **浏览器兼容性**：在不同浏览器中可能存在细微差异，以 Chrome 浏览器为准

## 7. 联系方式

- **作者**：前端川
- **网站**：[https://www.vsqdc.cn](https://www.vsqdc.cn)
- **反馈建议**：欢迎通过网站留言或邮件反馈使用过程中的问题和建议

## 8. 版本信息

- **当前版本**：1.0.0
- **发布日期**：2024-01-04
- **更新日志**：
  - 初始版本发布
  - 包含首页、分类导航、精选推荐、关于我们四个页面
  - 支持 PC 端和移动端响应式适配
  - 实现了基本的搜索功能和交互效果

---

通过以上使用说明，您可以轻松地安装、部署和使用文艺爱好者专属导航平台，享受优质的文艺资源导航服务。