# 精选优质资源导航平台目录结构

## 项目目录树形结构

```
h1678/
├── css/
│   └── style.css          # 主样式文件
├── doc/
│   ├── dirStru.md         # 目录结构文档
│   ├── projIntro.md       # 项目详细介绍
│   ├── techFeat.md        # 技术特点
│   └── userInstr.md       # 使用说明
├── img/
│   ├── category-1.svg     # 学习教育分类图标
│   ├── category-2.svg     # 开发工具分类图标
│   ├── category-3.svg     # 设计素材分类图标
│   ├── category-4.svg     # 生活服务分类图标
│   ├── feature-1.svg      # 精选资源功能图标
│   ├── feature-2.svg      # 分类清晰功能图标
│   ├── feature-3.svg      # 响应式设计功能图标
│   ├── feature-4.svg      # 持续更新功能图标
│   ├── logo.svg           # 网站Logo
│   ├── resource-1.svg     # 资源图标1
│   ├── resource-2.svg     # 资源图标2
│   ├── resource-3.svg     # 资源图标3
│   ├── resource-4.svg     # 资源图标4
│   ├── resource-5.svg     # 资源图标5
│   ├── resource-6.svg     # 资源图标6
│   ├── resource-7.svg     # 资源图标7
│   └── resource-8.svg     # 资源图标8
├── js/
│   └── main.js            # 主JavaScript文件
├── about.html             # 关于我们页面
├── categories.html        # 分类导航页面
├── index.html             # 首页
└── recommend.html         # 推荐资源页面
```

## 目录说明

### h1678/
- 项目根目录

### css/
- 存放CSS样式文件
- `style.css`：主样式文件，包含所有页面的样式定义

### doc/
- 存放项目文档
- `dirStru.md`：目录结构文档，描述项目的目录结构
- `projIntro.md`：项目详细介绍，描述项目的目标、功能和特点
- `techFeat.md`：技术特点文档，描述项目使用的技术和技术特点
- `userInstr.md`：使用说明文档，描述项目的使用方法和环境要求

### img/
- 存放项目图片资源
- `category-*.svg`：分类图标，用于展示不同类别的资源
- `feature-*.svg`：功能图标，用于展示平台的核心功能
- `logo.svg`：网站Logo，展示平台品牌标识
- `resource-*.svg`：资源图标，用于展示不同类型的资源

### js/
- 存放JavaScript文件
- `main.js`：主JavaScript文件，包含所有页面的交互逻辑

### HTML文件
- `index.html`：网站首页，展示平台的主要内容和功能入口
- `categories.html`：分类导航页面，展示不同类别的资源
- `recommend.html`：推荐资源页面，展示平台推荐的优质资源
- `about.html`：关于我们页面，介绍平台的背景和团队

## 文件命名规范

- 所有文件使用小写字母
- 单词之间使用连字符(-)分隔
- 文件名清晰描述文件内容
- 保持文件命名的一致性

## 代码组织规范

- 按功能模块组织代码
- 清晰的注释说明
- 统一的代码风格
- 便于维护和扩展