/**
 * @author: 前端川
 * @link: www.vsqdc.cn
 * @description: 精选优质资源导航平台主脚本文件
 */

// 页面加载完成后执行
document.addEventListener('DOMContentLoaded', function() {
    // 初始化移动端菜单
    initMobileMenu();
    
    // 初始化轮播图
    initBanner();
    
    // 初始化搜索功能
    initSearch();
    
    // 初始化平滑滚动
    initSmoothScroll();
});

/**
 * 初始化移动端菜单
 */
function initMobileMenu() {
    const menuBtn = document.getElementById('menuBtn');
    const mobileMenu = document.getElementById('mobileMenu');
    
    if (menuBtn && mobileMenu) {
        // 点击菜单按钮切换菜单显示状态
        menuBtn.addEventListener('click', function() {
            mobileMenu.classList.toggle('active');
            
            // 切换菜单按钮样式
            this.classList.toggle('active');
        });
        
        // 点击菜单外部关闭菜单
        document.addEventListener('click', function(e) {
            if (!menuBtn.contains(e.target) && !mobileMenu.contains(e.target)) {
                mobileMenu.classList.remove('active');
                menuBtn.classList.remove('active');
            }
        });
    }
}

/**
 * 初始化轮播图
 */
function initBanner() {
    const bannerItems = document.querySelectorAll('.banner-item');
    const indicators = document.querySelectorAll('.indicator');
    
    if (bannerItems.length === 0) return;
    
    let currentIndex = 0;
    const totalItems = bannerItems.length;
    const autoPlayInterval = 3000; // 自动播放间隔时间（毫秒）
    let autoPlayTimer = null;
    
    // 显示指定索引的轮播项
    function showBanner(index) {
        // 隐藏所有轮播项
        bannerItems.forEach(item => {
            item.classList.remove('active');
        });
        
        // 更新指示器状态
        indicators.forEach(indicator => {
            indicator.classList.remove('active');
        });
        
        // 显示当前轮播项和指示器
        bannerItems[index].classList.add('active');
        indicators[index].classList.add('active');
        
        // 更新当前索引
        currentIndex = index;
    }
    
    // 显示下一个轮播项
    function nextBanner() {
        const nextIndex = (currentIndex + 1) % totalItems;
        showBanner(nextIndex);
    }
    
    // 显示上一个轮播项
    function prevBanner() {
        const prevIndex = (currentIndex - 1 + totalItems) % totalItems;
        showBanner(prevIndex);
    }
    
    // 绑定指示器点击事件
    indicators.forEach((indicator, index) => {
        indicator.addEventListener('click', function() {
            showBanner(index);
            // 重置自动播放定时器
            resetAutoPlay();
        });
    });
    
    // 自动播放功能
    function startAutoPlay() {
        autoPlayTimer = setInterval(nextBanner, autoPlayInterval);
    }
    
    // 重置自动播放定时器
    function resetAutoPlay() {
        if (autoPlayTimer) {
            clearInterval(autoPlayTimer);
            startAutoPlay();
        }
    }
    
    // 开始自动播放
    startAutoPlay();
    
    // 鼠标悬停时暂停自动播放
    const banner = document.querySelector('.banner');
    if (banner) {
        banner.addEventListener('mouseenter', function() {
            if (autoPlayTimer) {
                clearInterval(autoPlayTimer);
            }
        });
        
        // 鼠标离开时恢复自动播放
        banner.addEventListener('mouseleave', function() {
            startAutoPlay();
        });
    }
}

/**
 * 初始化搜索功能
 */
function initSearch() {
    const searchInput = document.querySelector('.search-input');
    const searchBtn = document.querySelector('.search-btn');
    
    if (searchInput && searchBtn) {
        // 点击搜索按钮执行搜索
        searchBtn.addEventListener('click', function() {
            performSearch();
        });
        
        // 按下回车键执行搜索
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                performSearch();
            }
        });
    }
    
    // 执行搜索操作
    function performSearch() {
        const searchTerm = searchInput.value.trim();
        if (searchTerm) {
            // 这里可以添加实际的搜索逻辑
            alert(`搜索: ${searchTerm}`);
        } else {
            alert('请输入搜索关键词');
        }
    }
}

/**
 * 初始化平滑滚动
 */
function initSmoothScroll() {
    // 获取所有带有锚点链接的元素
    const anchorLinks = document.querySelectorAll('a[href^="#"]');
    
    anchorLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            const targetId = this.getAttribute('href');
            
            // 确保是页面内锚点链接
            if (targetId === '#') return;
            
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                e.preventDefault();
                
                // 计算滚动位置（考虑固定头部高度）
                const headerHeight = 80; // 与CSS中.main的margin-top保持一致
                const targetPosition = targetElement.offsetTop - headerHeight;
                
                // 平滑滚动
                window.scrollTo({
                    top: targetPosition,
                    behavior: 'smooth'
                });
            }
        });
    });
}

/**
 * 添加元素进入视口时的动画效果
 */
function initScrollAnimations() {
    // 这里可以添加滚动触发的动画效果
    // 例如：当元素进入视口时添加淡入、上移等动画
    const animatedElements = document.querySelectorAll('.animate-on-scroll');
    
    // 检查元素是否在视口中
    function isInViewport(element) {
        const rect = element.getBoundingClientRect();
        return (
            rect.top <= (window.innerHeight || document.documentElement.clientHeight) * 0.8 &&
            rect.bottom >= 0
        );
    }
    
    // 处理滚动事件
    function handleScroll() {
        animatedElements.forEach(element => {
            if (isInViewport(element)) {
                element.classList.add('animated');
            }
        });
    }
    
    // 初始检查
    handleScroll();
    
    // 添加滚动事件监听
    window.addEventListener('scroll', handleScroll);
}

/**
 * 初始化资源卡片交互效果
 */
function initResourceCards() {
    const resourceCards = document.querySelectorAll('.resource-card');
    
    resourceCards.forEach(card => {
        // 鼠标悬停效果已通过CSS实现
        // 这里可以添加更多交互效果
    });
}

/**
 * 页面滚动时的导航栏效果
 */
function initScrollHeader() {
    const header = document.querySelector('.header');
    if (!header) return;
    
    window.addEventListener('scroll', function() {
        if (window.scrollY > 50) {
            header.style.boxShadow = '0 4px 20px rgba(0, 0, 0, 0.15)';
            header.style.backgroundColor = 'rgba(255, 255, 255, 0.98)';
            header.style.backdropFilter = 'blur(10px)';
        } else {
            header.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.1)';
            header.style.backgroundColor = '#fff';
            header.style.backdropFilter = 'none';
        }
    });
}

/**
 * 获取当前页面URL的路径部分
 * @returns {string} 当前页面路径
 */
function getCurrentPagePath() {
    return window.location.pathname.split('/').pop() || 'index.html';
}

/**
 * 高亮当前页面的导航链接
 */
function highlightCurrentNavLink() {
    const currentPage = getCurrentPagePath();
    const navLinks = document.querySelectorAll('.nav-link, .mobile-nav-link');
    
    navLinks.forEach(link => {
        const linkPage = link.getAttribute('href').split('/').pop() || 'index.html';
        
        if (linkPage === currentPage) {
            link.classList.add('active');
        } else {
            link.classList.remove('active');
        }
    });
}

// 页面加载完成后执行所有初始化函数
document.addEventListener('DOMContentLoaded', function() {
    // 初始化移动端菜单
    initMobileMenu();
    
    // 初始化轮播图
    initBanner();
    
    // 初始化搜索功能
    initSearch();
    
    // 初始化平滑滚动
    initSmoothScroll();
    
    // 初始化滚动动画
    initScrollAnimations();
    
    // 初始化资源卡片
    initResourceCards();
    
    // 初始化滚动时的导航栏效果
    initScrollHeader();
    
    // 高亮当前页面导航链接
    highlightCurrentNavLink();
});
