# 深耕行业资讯优质导航合集 - 目录结构

## 项目目录树

```
b1690/                 # 项目根目录
├── css/               # CSS样式文件目录
│   └── style.css      # 主样式文件，包含所有页面的样式定义
├── doc/               # 项目文档目录
│   ├── projIntro.md   # 项目详细介绍文档
│   ├── techFeat.md    # 技术特点文档
│   ├── dirStru.md     # 目录结构文档
│   └── userInstr.md   # 使用说明文档
├── img/               # 图片资源目录
│   ├── logo.svg       # 网站Logo图片
│   ├── search.svg     # 搜索图标
│   ├── menu.svg       # 移动端菜单图标
│   ├── tech.svg       # 科技资讯分类图标
│   ├── design.svg     # 设计资源分类图标
│   ├── dev.svg        # 开发工具分类图标
│   ├── learn.svg      # 学习资源分类图标
│   ├── marketing.svg  # 营销推广分类图标
│   ├── tools.svg      # 实用工具分类图标
│   ├── website1.svg   # 网站图标1
│   ├── website2.svg   # 网站图标2
│   ├── website3.svg   # 网站图标3
│   ├── website4.svg   # 网站图标4
│   ├── feature1.svg   # 特性图标1（精选优质网站）
│   ├── feature2.svg   # 特性图标2（分类清晰）
│   ├── feature3.svg   # 特性图标3（响应式设计）
│   └── default.svg    # 默认图片图标（用于图片加载失败时）
├── js/                # JavaScript文件目录
│   └── main.js        # 主JavaScript文件，包含所有页面的交互功能
├── index.html         # 首页HTML文件
├── tech.html          # 科技资讯分类页面
├── design.html        # 设计资源分类页面
├── dev.html           # 开发工具分类页面
└── about.html         # 关于我们页面
```

## 目录说明

### 根目录 (b1690/)
项目的主目录，包含所有项目文件和子目录。

### CSS目录 (css/)
存放所有CSS样式文件，目前只有一个主样式文件style.css，包含了所有页面的样式定义，包括响应式设计、动画效果、布局样式等。

### 文档目录 (doc/)
存放项目相关文档，包括：
- projIntro.md：详细介绍项目的背景、目标、功能和设计风格
- techFeat.md：说明项目的技术栈、核心技术特点和实现方式
- dirStru.md：展示项目的目录结构和文件组织
- userInstr.md：提供项目的使用说明、环境要求和安装步骤

### 图片目录 (img/)
存放项目中使用的所有图片资源，全部采用SVG格式，包括：
- 网站Logo和导航图标
- 分类页面图标
- 网站列表中的网站图标
- 关于我们页面的特性图标
- 默认图片图标（用于图片加载失败时的备选显示）

### JavaScript目录 (js/)
存放所有JavaScript文件，目前只有一个主JavaScript文件main.js，包含了所有页面的交互功能，如移动端菜单、轮播图、搜索功能、滚动效果等。

### HTML文件
项目包含5个HTML文件，构成了网站的主要页面：
- index.html：网站首页，包含轮播图、分类导航和热门网站推荐
- tech.html：科技资讯分类页面，展示科技资讯相关网站
- design.html：设计资源分类页面，展示设计资源相关网站
- dev.html：开发工具分类页面，展示开发工具相关网站
- about.html：关于我们页面，介绍网站的背景、特点和联系方式

## 文件命名规范

- HTML文件：使用小写字母和连字符命名，如tech-news.html
- CSS文件：使用小写字母和连字符命名，如style.css
- JavaScript文件：使用小写字母和连字符命名，如main.js
- 图片文件：使用小写字母和连字符命名，如logo.svg
- 文档文件：使用驼峰命名法，如projIntro.md

## 目录结构设计原则

1. **清晰的模块化组织**：按功能模块划分目录，便于维护和扩展
2. **资源与代码分离**：将CSS、JavaScript和图片资源分别存放在独立目录
3. **扁平化结构**：避免过深的目录嵌套，提高文件访问效率
4. **一致性命名**：采用统一的命名规范，提高代码可读性
5. **易于扩展**：预留了足够的扩展空间，便于未来添加新功能和模块

## 文件依赖关系

- 所有HTML文件依赖于css/style.css和js/main.js
- CSS文件不依赖其他文件
- JavaScript文件不依赖其他文件
- 所有页面都使用img/目录下的图片资源

## 项目结构特点

1. **纯前端实现**：不依赖后端服务，所有功能都通过前端技术实现
2. **响应式设计**：适配PC端和移动端，提供良好的跨设备体验
3. **模块化代码**：代码结构清晰，便于维护和扩展
4. **资源优化**：使用SVG格式图片，减少文件体积，提高加载速度
5. **易于部署**：只需要一个静态文件服务器即可部署运行

## 扩展建议

- 未来添加新功能时，可以在现有目录结构基础上扩展
- 如添加新的分类页面，只需在根目录添加对应的HTML文件
- 如添加新的功能模块，可以在js/目录下添加对应的JavaScript文件
- 如添加新的样式模块，可以考虑将CSS文件拆分，提高代码组织性

## 总结

本项目采用了清晰、合理的目录结构设计，便于开发、维护和扩展。通过将不同类型的文件分类存放，提高了代码的可读性和可维护性。同时，项目结构也考虑了未来的扩展性，为后续功能的添加预留了空间。