# 聚焦生活服务实用导航站点 - 目录结构

## 项目目录树形结构

```
u1688/
├── css/             # CSS样式文件目录
│   └── style.css    # 主样式文件，包含所有页面的样式定义
├── js/              # JavaScript文件目录
│   └── main.js      # 主JavaScript文件，包含所有页面的交互功能
├── img/             # 图片资源目录，所有图片均为SVG格式
│   ├── logo.svg     # 网站LOGO图片
│   ├── search.svg   # 搜索图标
│   ├── menu.svg     # 菜单图标
│   ├── food.svg     # 美食餐饮分类图标
│   ├── travel.svg   # 旅游出行分类图标
│   ├── shopping.svg # 购物消费分类图标
│   ├── life.svg     # 生活服务分类图标
│   ├── education.svg # 教育学习分类图标
│   ├── entertainment.svg # 娱乐休闲分类图标
│   ├── website1.svg # 推荐网站1 LOGO
│   ├── website2.svg # 推荐网站2 LOGO
│   ├── website3.svg # 推荐网站3 LOGO
│   ├── website4.svg # 推荐网站4 LOGO
│   ├── website5.svg # 推荐网站5 LOGO
│   └── website6.svg # 推荐网站6 LOGO
├── doc/             # 项目文档目录
│   ├── projIntro.md # 项目详细介绍文档
│   ├── techFeat.md  # 技术特点文档
│   ├── dirStru.md   # 目录结构文档
│   └── userInstr.md # 使用说明文档
├── index.html       # 网站首页，包含轮播图、分类导航、推荐网站等
└── category.html    # 分类页面，支持按分类浏览和筛选网站
```

## 目录结构详细说明

### 1. 根目录 u1688

项目的根目录，包含所有项目文件和子目录。

### 2. css/ 目录

存放项目的CSS样式文件，采用外部样式表的方式管理样式。

- **style.css**：主样式文件，包含所有页面的样式定义，包括布局、颜色、字体、响应式设计等。

### 3. js/ 目录

存放项目的JavaScript文件，采用外部脚本的方式管理交互功能。

- **main.js**：主JavaScript文件，包含所有页面的交互功能，如轮播图、移动端菜单、搜索功能、平滑滚动等。

### 4. img/ 目录

存放项目的图片资源，所有图片均采用SVG格式，确保图片清晰度和加载性能。

- **logo.svg**：网站的LOGO图片，位于页面顶部左侧。
- **search.svg**：搜索图标，位于搜索框内。
- **menu.svg**：移动端菜单图标，位于页面顶部右侧。
- **分类图标**：包括美食餐饮、旅游出行、购物消费、生活服务、教育学习、娱乐休闲等分类的图标，用于分类导航卡片。
- **推荐网站LOGO**：6个推荐网站的LOGO图片，用于推荐网站列表。

### 5. doc/ 目录

存放项目的文档文件，采用Markdown格式编写，便于阅读和维护。

- **projIntro.md**：项目详细介绍文档，包含项目背景、目标、核心功能、面向用户等信息。
- **techFeat.md**：技术特点文档，包含技术栈概述、前端技术详情、核心技术特点等信息。
- **dirStru.md**：目录结构文档，包含项目目录树形结构和详细说明。
- **userInstr.md**：使用说明文档，包含环境要求、安装步骤、使用方法等信息。

### 6. 主要HTML文件

- **index.html**：网站的首页，包含轮播图展示、热门分类导航、推荐网站列表和快速链接区域。
- **category.html**：分类页面，支持按不同分类浏览网站，并提供二级筛选功能。

## 目录结构设计原则

1. **模块化设计**：将不同类型的文件分离到不同的目录中，便于管理和维护。
2. **清晰的命名**：目录和文件命名清晰，能够直观反映其功能和用途。
3. **易于扩展**：目录结构设计考虑到未来功能扩展的需求，便于添加新的文件和功能。
4. **响应式支持**：文件结构支持PC端和移动端的响应式设计。
5. **性能优化**：图片资源采用SVG格式，确保加载性能和清晰度。

## 项目文件关系

- **HTML文件**：负责页面结构和内容展示，引入CSS和JavaScript文件。
- **CSS文件**：负责页面样式设计，包括布局、颜色、字体、动画等。
- **JavaScript文件**：负责页面交互功能，包括轮播图、菜单、搜索等。
- **图片资源**：增强页面视觉效果，包括LOGO、图标、分类图标、网站LOGO等。
- **文档文件**：提供项目的详细信息，便于用户了解和使用项目。

## 项目文件依赖关系

```
index.html ──┬──> css/style.css
             └──> js/main.js
             └──> img/*.svg

category.html ──┬──> css/style.css
               └──> js/main.js
               └──> img/*.svg
```

所有HTML文件都依赖于相同的CSS和JavaScript文件，确保样式和功能的一致性。图片资源被HTML文件引用，用于页面的视觉展示。