# 聚焦生活服务实用导航站点 - 使用说明

## 1. 环境要求

本项目为纯前端项目，不需要任何后端服务或数据库，因此环境要求非常简单：

### 1.1 硬件要求

- 普通计算机或移动设备
- 能够连接互联网（用于访问外部网站）

### 1.2 软件要求

- **Web浏览器**：支持HTML5、CSS3和ES6+的现代浏览器
  - Chrome 60+
  - Firefox 55+
  - Safari 12+
  - Edge 79+
  - 移动端浏览器：iOS Safari 12+、Chrome for Android 60+

## 2. 安装步骤

由于本项目是纯前端项目，不需要复杂的安装过程，只需将项目文件下载到本地即可使用。

### 2.1 下载项目文件

1. 将项目文件下载到本地计算机
2. 解压下载的压缩包（如果是压缩包格式）
3. 确保项目文件结构完整

### 2.2 本地运行

#### 方法1：直接打开HTML文件

1. 找到项目根目录下的 `index.html` 文件
2. 双击该文件，系统会自动用默认浏览器打开
3. 即可访问网站首页

#### 方法2：使用本地HTTP服务器（推荐）

为了避免某些浏览器的跨域限制，推荐使用本地HTTP服务器运行项目：

**使用Python内置HTTP服务器**：

1. 打开命令行工具（CMD或PowerShell）
2. 进入项目根目录：`cd d:/vsqdc/prj1/code/k3/u1688`
3. 运行命令：
   - Python 3.x：`python -m http.server 8000`
   - Python 2.x：`python -m SimpleHTTPServer 8000`
4. 在浏览器中访问：`http://localhost:8000`

**使用Node.js的http-server**：

1. 确保已安装Node.js
2. 全局安装http-server：`npm install -g http-server`
3. 进入项目根目录：`cd d:/vsqdc/prj1/code/k3/u1688`
4. 运行命令：`http-server -p 8000`
5. 在浏览器中访问：`http://localhost:8000`

## 3. 网站使用方法

### 3.1 首页功能

1. **轮播图**：展示热门分类，点击可直接进入对应分类页面
2. **热门分类**：点击分类卡片，进入对应分类页面
3. **推荐网站**：浏览推荐的优质生活服务网站，点击可直接访问
4. **快速链接**：点击快速链接，快速访问常用服务
5. **搜索功能**：在搜索框中输入关键词，点击搜索按钮或按回车键进行搜索
6. **导航菜单**：点击导航菜单中的链接，切换到不同页面

### 3.2 分类页面功能

1. **分类标题**：显示当前分类名称和描述
2. **筛选功能**：
   - 点击筛选按钮，按二级分类筛选网站
   - 点击"全部"按钮，显示所有网站
3. **网站列表**：
   - 浏览当前分类下的网站
   - 点击网站卡片，直接访问该网站
   - 查看网站名称和描述信息

### 3.3 移动端使用

1. **移动端菜单**：
   - 点击页面右上角的菜单按钮，展开移动端菜单
   - 点击菜单外区域或菜单链接，关闭菜单
2. **响应式布局**：页面会根据屏幕尺寸自动调整布局
3. **触摸友好**：所有交互元素都适合触摸操作

## 4. 网站功能说明

### 4.1 导航功能

- **首页导航**：从首页可以快速访问所有主要功能
- **分类导航**：按分类浏览网站，便于查找特定类型的服务
- **快速链接**：提供常用服务的快捷访问

### 4.2 搜索功能

- 支持关键词搜索网站
- 搜索结果会高亮显示匹配的关键词
- 支持回车键触发搜索

### 4.3 筛选功能

- 支持按二级分类筛选网站
- 筛选结果实时更新
- 支持恢复全部显示

### 4.4 响应式设计

- 适配PC端、平板和移动端
- 不同屏幕尺寸下的布局优化
- 移动端友好的交互设计

## 5. 网站维护与更新

### 5.1 添加新网站

1. 打开对应的HTML文件（`index.html` 或 `category.html`）
2. 找到网站列表区域
3. 添加新的网站卡片：
   ```html
   <a href="#" class="website-item" data-category="分类">
       <div class="website-logo">
           <img src="img/websiteX.svg" alt="网站名称">
       </div>
       <div class="website-info">
           <h3>网站名称</h3>
           <p>网站描述</p>
       </div>
   </a>
   ```
4. 如果需要添加新的网站LOGO，将SVG图片添加到 `img/` 目录下

### 5.2 修改网站信息

1. 打开对应的HTML文件
2. 找到需要修改的网站卡片
3. 修改网站名称、描述、链接或分类信息
4. 保存文件

### 5.3 更新样式

1. 打开 `css/style.css` 文件
2. 修改对应的CSS样式规则
3. 保存文件
4. 刷新浏览器查看效果

### 5.4 更新交互功能

1. 打开 `js/main.js` 文件
2. 修改或添加JavaScript代码
3. 保存文件
4. 刷新浏览器查看效果

## 6. 常见问题及解决方案

### 6.1 网站图片不显示

**解决方案**：
- 检查图片文件路径是否正确
- 确保图片文件格式为SVG
- 检查图片文件是否存在
- 清除浏览器缓存

### 6.2 交互功能不工作

**解决方案**：
- 检查浏览器控制台是否有JavaScript错误
- 确保JavaScript文件路径正确
- 检查JavaScript代码是否有语法错误
- 确保浏览器支持ES6+语法

### 6.3 页面布局错乱

**解决方案**：
- 检查浏览器是否支持CSS Grid和Flexbox
- 确保CSS文件路径正确
- 清除浏览器缓存
- 检查HTML结构是否正确

### 6.4 移动端显示异常

**解决方案**：
- 检查viewport meta标签是否正确设置
- 确保媒体查询语法正确
- 测试不同移动设备和浏览器

## 7. 浏览器兼容性

本项目在以下浏览器中经过测试，能够正常工作：

- **桌面端**：
  - Chrome 80+：完美支持
  - Firefox 75+：完美支持
  - Safari 13+：完美支持
  - Edge 80+：完美支持

- **移动端**：
  - iOS Safari 13+：完美支持
  - Chrome for Android 80+：完美支持
  - 华为浏览器：完美支持
  - 小米浏览器：完美支持

## 8. 部署到服务器

### 8.1 静态网站托管

本项目可以部署到任何静态网站托管服务：

- **GitHub Pages**：免费托管，适合个人项目
- **Netlify**：免费托管，支持自动部署
- **Vercel**：免费托管，适合前端项目
- **阿里云OSS**：对象存储服务，支持静态网站托管
- **腾讯云COS**：对象存储服务，支持静态网站托管
- **传统Web服务器**：如Apache、Nginx等

### 8.2 部署步骤

1. 将项目文件上传到服务器或托管服务
2. 确保服务器配置正确，支持静态文件访问
3. 访问网站域名，验证部署是否成功

## 9. 联系方式

- 项目作者：前端川
- 官方网站：[https://www.vsqdc.cn](https://www.vsqdc.cn)
- 如有问题或建议，欢迎访问官方网站反馈

## 10. 版权信息

本项目采用MIT许可证，可自由使用、修改和分发。

版权所有 © 2026 前端川