# 极简风格清爽整洁导航页 - 目录结构

## 项目目录结构

```
m1689/
├── css/                  # CSS样式文件目录
│   └── style.css         # 主样式文件，包含所有页面样式
├── img/                  # 图片资源目录
│   └── logo.svg          # 网站Logo，SVG格式
├── js/                   # JavaScript文件目录
│   └── main.js           # 主JavaScript文件，包含所有交互逻辑
├── doc/                  # 文档目录
│   ├── projIntro.md      # 项目详细介绍
│   ├── techFeat.md       # 技术特点说明
│   ├── dirStru.md        # 目录结构说明
│   └── userInstr.md      # 使用说明文档
├── index.html            # 首页，网站导航主页面
├── tools.html            # 工具页面，常用在线工具推荐
└── about.html            # 关于页面，网站介绍和相关信息
```

## 目录说明

### m1689/
- 项目根目录，包含所有项目文件

### css/
- 存放CSS样式文件
- **style.css**：主样式文件，包含所有页面的样式定义，包括布局、颜色、字体、动画效果等

### img/
- 存放图片资源文件
- **logo.svg**：网站Logo，采用SVG格式，支持无损缩放，加载速度快

### js/
- 存放JavaScript文件
- **main.js**：主JavaScript文件，包含页面交互逻辑、搜索功能、移动端菜单等功能实现

### doc/
- 存放项目文档
- **projIntro.md**：项目详细介绍，包括项目背景、目标、功能、设计理念等
- **techFeat.md**：技术特点说明，包括技术栈、核心技术特点、关键技术实现等
- **dirStru.md**：目录结构说明，以树形结构呈现项目文件组织
- **userInstr.md**：使用说明文档，包括环境要求、安装步骤、使用方法等

### index.html
- 网站首页，展示常用网站导航，包含搜索功能和网站分类展示

### tools.html
- 工具页面，推荐常用在线工具，按分类展示，方便用户快速访问

### about.html
- 关于页面，介绍网站的背景、设计理念、核心特点、技术栈等信息