# 极简风格清爽整洁导航页 - 使用说明

## 1. 环境要求

### 1.1 硬件要求
- 任何能运行现代浏览器的设备
- 建议配置：CPU 1GHz以上，内存 512MB以上

### 1.2 软件要求
- **浏览器**：支持HTML5、CSS3、JavaScript的现代浏览器
  - Chrome 60+ 推荐
  - Firefox 55+ 推荐
  - Safari 12+ 推荐
  - Edge 79+ 推荐
  - IE 11+ 兼容

## 2. 安装步骤

### 2.1 本地部署

由于本项目是纯前端实现，无需服务器环境，可直接本地访问。

#### 步骤1：获取项目文件
- 下载项目压缩包
- 解压到本地任意目录

#### 步骤2：访问网站
- 打开解压后的项目目录
- 找到 `index.html` 文件
- 双击 `index.html` 文件，或使用浏览器打开该文件
- 网站将在浏览器中打开

### 2.2 服务器部署

如果需要将网站部署到服务器上，可按照以下步骤操作：

#### 步骤1：准备服务器
- 确保服务器已安装Web服务器软件（如Apache、Nginx等）
- 确保服务器支持静态文件访问

#### 步骤2：上传项目文件
- 将项目所有文件上传到服务器的Web根目录或指定目录
- 确保文件结构保持不变

#### 步骤3：配置服务器
- 根据Web服务器软件的要求，配置虚拟主机或路径映射
- 确保服务器允许访问HTML、CSS、JavaScript和SVG文件

#### 步骤4：访问网站
- 使用浏览器访问服务器的IP地址或域名
- 网站将在浏览器中打开

## 3. 使用方法

### 3.1 网站导航

#### 首页功能
- **搜索框**：在搜索框中输入关键词，点击搜索按钮或按回车键进行搜索
- **网站分类**：浏览不同分类下的常用网站
- **网站访问**：点击网站卡片，直接跳转到对应网站

#### 工具页面
- **工具分类**：浏览不同分类下的常用在线工具
- **工具访问**：点击工具卡片，直接跳转到对应工具

#### 关于页面
- **网站介绍**：了解网站的背景、设计理念等信息
- **技术栈**：查看网站使用的技术和实现方式
- **联系方式**：获取网站的联系方式

### 3.2 移动端使用

#### 菜单操作
- 点击右上角的菜单按钮，展开导航菜单
- 点击导航链接，跳转到对应页面
- 再次点击菜单按钮，关闭导航菜单

#### 触控优化
- 网站卡片和按钮支持触控操作
- 优化了移动端的浏览体验
- 适配不同屏幕尺寸

### 3.3 搜索功能

#### 搜索方法
- 在搜索框中输入关键词
- 点击搜索按钮或按回车键进行搜索
- 搜索结果将在新窗口中打开

#### 搜索建议
- 支持实时搜索建议
- 记录搜索历史，方便再次搜索

## 4. 自定义和扩展

### 4.1 添加新网站

1. 打开 `index.html` 文件
2. 在对应分类的 `sites-grid` 中添加新的网站卡片
3. 按照现有网站卡片的格式，填写网站链接、名称和图标
4. 保存文件，刷新页面即可看到新添加的网站

### 4.2 修改样式

1. 打开 `css/style.css` 文件
2. 根据需要修改样式，如颜色、字体、布局等
3. 保存文件，刷新页面即可看到修改效果

### 4.3 添加新功能

1. 打开 `js/main.js` 文件
2. 添加新的功能模块
3. 按照现有代码的模块化结构，组织新功能代码
4. 保存文件，刷新页面即可使用新功能

## 5. 常见问题

### 5.1 网站无法正常显示

**问题**：打开网站后，页面显示异常或功能无法使用

**解决方案**：
- 检查浏览器版本，确保使用现代浏览器
- 清除浏览器缓存，刷新页面重试
- 检查网络连接，确保网络正常
- 检查文件路径，确保文件结构正确

### 5.2 搜索功能无法使用

**问题**：在搜索框中输入关键词后，点击搜索按钮没有反应

**解决方案**：
- 检查浏览器是否禁用了JavaScript
- 确保网络连接正常
- 检查 `js/main.js` 文件是否存在且完整

### 5.3 移动端菜单无法正常工作

**问题**：在移动端设备上，点击菜单按钮没有反应

**解决方案**：
- 检查浏览器是否支持CSS transform和transition
- 确保 `js/main.js` 文件正常加载
- 检查 `index.html` 中菜单按钮的ID是否正确

## 6. 更新和维护

### 6.1 更新网站内容

- 定期检查和更新常用网站链接
- 根据用户反馈，添加新的常用网站
- 移除失效的网站链接

### 6.2 优化网站性能

- 定期优化图片资源，减少加载时间
- 优化CSS和JavaScript代码，提高执行效率
- 添加新的功能和交互效果，提升用户体验

### 6.3 安全维护

- 定期检查网站链接的安全性
- 确保所有外部链接都是安全可靠的
- 避免添加恶意网站链接

## 7. 联系方式

如果您在使用过程中遇到任何问题，或有任何建议和意见，欢迎通过以下方式联系我们：

- 作者：前端川
- 网站：[www.vsqdc.cn](https://www.vsqdc.cn)

## 8. 版本历史

- **v1.0.0**（2026-01-04）：初始版本发布
  - 实现基本的网站导航功能
  - 支持搜索功能
  - 实现响应式设计
  - 添加常用工具推荐

- **v1.0.1**（2026-01-05）：功能优化
  - 优化搜索功能
  - 改进移动端适配
  - 添加更多网站资源

- **v1.0.2**（2026-01-06）：体验优化
  - 添加网站卡片悬停效果
  - 改进动画效果
  - 优化代码结构

---

感谢您使用极简风格清爽整洁导航页！我们将持续优化和更新，为您提供更好的使用体验。