# 目录结构

```
w1679/
├── css/                    # CSS样式文件目录
│   └── style.css           # 主样式文件，包含所有样式定义
├── img/                    # 图片资源目录，所有图片均为SVG格式
│   ├── logo.svg            # 网站LOGO
│   ├── website1.svg        # 网站图标1（招聘网站）
│   ├── website2.svg        # 网站图标2（学习平台）
│   ├── website3.svg        # 网站图标3（办公工具）
│   ├── website4.svg        # 网站图标4（行业资讯）
│   ├── category1.svg       # 分类图标1（招聘求职）
│   ├── category2.svg       # 分类图标2（学习提升）
│   ├── category3.svg       # 分类图标3（办公工具）
│   ├── category4.svg       # 分类图标4（行业资讯）
│   ├── category5.svg       # 分类图标5（金融理财）
│   ├── category6.svg       # 分类图标6（生活服务）
│   ├── empty.svg           # 空收藏状态图标
│   ├── contact1.svg        # 联系图标1（邮箱）
│   ├── contact2.svg        # 联系图标2（微信）
│   └── contact3.svg        # 联系图标3（微博）
├── js/                     # JavaScript文件目录
│   └── main.js             # 主JavaScript文件，实现各种交互功能
├── doc/                    # 文档目录，包含4份中文文档
│   ├── projIntro.md        # 项目详细介绍
│   ├── techFeat.md         # 技术特点
│   ├── dirStru.md          # 目录结构
│   └── userInstr.md        # 使用说明
├── index.html              # 网站首页
├── category.html           # 分类导航页面
├── favorites.html          # 我的收藏页面
└── about.html              # 关于我们页面
```

## 目录说明

### 根目录 (w1679/)
包含网站的所有文件和文件夹，是项目的根目录。

### css/
存放所有CSS样式文件，目前只有一个主样式文件style.css，包含网站的所有样式定义，包括响应式设计、动画效果和各种组件样式。

### img/
存放网站所需的所有图片资源，所有图片均为SVG格式，包括：
- 网站LOGO
- 各类网站图标
- 分类图标
- 空收藏状态图标
- 联系图标

### js/
存放JavaScript文件，目前只有一个主JavaScript文件main.js，实现网站的各种交互功能，如：
- 移动端菜单
- 搜索功能
- 收藏功能
- 平滑滚动
- 页面加载动画

### doc/
存放项目的配套文档，包含4份中文文档：
- projIntro.md：项目详细介绍，介绍项目的概述、定位、功能模块等
- techFeat.md：技术特点，介绍项目的技术实现和核心技术特点
- dirStru.md：目录结构，以树形结构呈现项目的文件组织
- userInstr.md：使用说明，包含环境要求、安装步骤等

### HTML文件
- index.html：网站首页，包含网站的主要内容和导航
- category.html：分类导航页面，按领域展示网站分类和列表
- favorites.html：我的收藏页面，展示用户收藏的网站
- about.html：关于我们页面，介绍网站的定位、使命和联系方式

## 文件命名规范

- **HTML文件**：使用小写字母，单词之间用连字符分隔
- **CSS文件**：使用小写字母，单词之间用连字符分隔
- **JavaScript文件**：使用小写字母，单词之间用连字符分隔
- **图片文件**：使用小写字母，单词之间用连字符分隔
- **文档文件**：使用驼峰命名法，首字母大写

## 代码组织原则

- **模块化**：按功能模块组织代码
- **语义化**：使用语义化的标签和类名
- **可维护性**：代码结构清晰，便于维护和扩展
- **性能优化**：优化代码结构和执行效率

通过以上目录结构和文件组织，项目具有良好的可维护性和扩展性，便于后续功能的添加和修改。