# 使用说明

## 1. 环境要求

### 1.1 硬件要求

- 无特殊硬件要求，普通计算机即可
- 建议使用现代设备，确保良好的显示效果

### 1.2 软件要求

- **操作系统**：支持Windows、macOS、Linux等主流操作系统
- **浏览器**：支持现代浏览器，建议使用以下浏览器的最新版本：
  - Chrome ≥ 60
  - Firefox ≥ 55
  - Safari ≥ 12
  - Edge ≥ 79

### 1.3 网络要求

- 网站可离线访问，无需网络连接
- 访问外部链接时需要网络连接

## 2. 安装步骤

### 2.1 下载项目

1. 从项目地址下载项目文件
2. 将项目文件解压到本地目录

### 2.2 部署方式

#### 2.2.1 本地直接访问

1. 打开项目根目录（w1679）
2. 双击 `index.html` 文件
3. 浏览器会自动打开网站首页

#### 2.2.2 使用本地服务器

如果您需要使用本地服务器访问网站（推荐，避免某些浏览器的本地文件限制），可以使用以下方法：

##### 方法1：使用Python内置服务器（推荐）

1. 打开命令行终端
2. 进入项目根目录（w1679）
3. 运行以下命令：
   - Python 3：`python -m http.server 8000`
   - Python 2：`python -m SimpleHTTPServer 8000`
4. 在浏览器中访问 `http://localhost:8000`

##### 方法2：使用Node.js的http-server

1. 确保已安装Node.js
2. 全局安装http-server：`npm install -g http-server`
3. 进入项目根目录（w1679）
4. 运行命令：`http-server -p 8000`
5. 在浏览器中访问 `http://localhost:8000`

##### 方法3：使用其他本地服务器软件

您也可以使用其他本地服务器软件，如WAMP、XAMPP等，将项目文件放置在服务器的根目录下，然后通过浏览器访问。

## 3. 使用指南

### 3.1 网站首页

1. **搜索功能**：在搜索框中输入关键词，点击搜索按钮或按下回车键进行搜索
2. **热门推荐**：点击热门推荐卡片，直接访问对应的网站
3. **分类导航**：点击分类卡片，进入分类导航页面
4. **快速访问**：点击快速访问链接，直接访问常用网站
5. **导航菜单**：点击导航菜单，切换到其他页面

### 3.2 分类导航

1. **浏览分类**：在分类导航页面，浏览不同领域的网站分类
2. **查看网站列表**：点击分类标题，查看该分类下的网站列表
3. **访问网站**：点击网站列表中的「访问」按钮，直接访问网站
4. **收藏网站**：点击网站列表中的「收藏」按钮，将网站添加到收藏

### 3.3 我的收藏

1. **查看收藏**：在我的收藏页面，查看已收藏的网站列表
2. **访问收藏网站**：点击收藏列表中的「访问」按钮，直接访问网站
3. **取消收藏**：点击收藏列表中的「收藏」按钮，取消收藏该网站
4. **空收藏状态**：如果没有收藏网站，会显示空收藏提示，点击「去首页」按钮返回首页

### 3.4 关于我们

1. **了解网站**：在关于我们页面，了解网站的定位、使命和愿景
2. **联系方式**：查看网站的联系方式
3. **合作邀请**：了解合作方式和流程

## 4. 移动端使用

### 4.1 访问方式

- 直接在移动设备浏览器中输入网站地址
- 或通过扫描二维码访问

### 4.2 移动端特性

- **响应式布局**：自动适配移动设备屏幕尺寸
- **移动端菜单**：点击右上角的汉堡菜单按钮，显示/隐藏导航菜单
- **触摸交互**：支持触摸操作，如点击、滑动等
- **优化的界面**：针对移动设备优化的界面设计，提高移动端用户体验

## 5. 常见问题

### 5.1 网站无法正常显示

- **检查浏览器版本**：确保使用的是现代浏览器的最新版本
- **清除浏览器缓存**：尝试清除浏览器缓存后重新访问
- **检查文件路径**：确保所有文件都在正确的位置，路径引用正确

### 5.2 交互功能无法正常使用

- **检查浏览器控制台**：按F12打开浏览器控制台，查看是否有JavaScript错误
- **检查JavaScript文件**：确保JavaScript文件已正确引入，且没有语法错误
- **检查网络连接**：某些功能可能需要网络连接

### 5.3 移动端显示异常

- **检查响应式设计**：确保CSS媒体查询设置正确
- **检查视口设置**：确保HTML头部的viewport meta标签设置正确

### 5.4 收藏功能无法保存

- **检查浏览器支持**：确保浏览器支持localStorage
- **检查存储权限**：确保浏览器允许使用localStorage
- **清除浏览器数据**：如果localStorage已满，尝试清除浏览器数据

## 6. 注意事项

1. 网站使用本地存储保存收藏数据，清除浏览器数据会导致收藏丢失
2. 网站提供的外部链接跳转至第三方网站，请注意网络安全
3. 建议定期备份收藏数据，避免数据丢失
4. 如有任何问题或建议，欢迎通过联系方式反馈

## 7. 更新日志

### 版本 1.0.0 (2025-12-26)

- 初始版本发布
- 实现核心功能：首页、分类导航、我的收藏、关于我们
- 支持PC端和移动端响应式适配
- 实现搜索、收藏、平滑滚动等交互功能
- 包含丰富的动画效果和过渡效果

## 8. 联系方式

- **邮箱**：contact@vsqdc.cn
- **微信**：vsqdc_official
- **微博**：@前端川
- **官网**：[https://www.vsqdc.cn](https://www.vsqdc.cn)