# 项目目录结构

```
k1669/
├── doc/                    # 项目文档目录
│   ├── projIntro.md        # 项目详细介绍
│   ├── techFeat.md         # 技术特点说明
│   ├── dirStru.md          # 目录结构文档
│   └── userInstr.md        # 使用说明文档
├── src/                    # 源代码目录
│   ├── assets/             # 静态资源目录
│   │   └── images/         # 图片资源目录
│   │       ├── logo.svg    # 企业LOGO
│   │       ├── hero.svg    # 首页轮播图
│   │       ├── service1.svg # 服务1图标
│   │       ├── service2.svg # 服务2图标
│   │       ├── service3.svg # 服务3图标
│   │       ├── service4.svg # 服务4图标
│   │       ├── team1.svg   # 团队成员1
│   │       ├── team2.svg   # 团队成员2
│   │       ├── team3.svg   # 团队成员3
│   │       ├── team4.svg   # 团队成员4
│   │       ├── location.svg # 地址图标
│   │       ├── phone.svg   # 电话图标
│   │       └── email.svg   # 邮箱图标
│   ├── styles/             # 样式文件目录
│   │   └── main.less       # 主样式文件
│   ├── App.vue             # 根组件
│   ├── main.ts             # 应用入口文件
│   └── vite-env.d.ts       # Vite环境类型声明
├── index.html              # HTML入口文件
├── package.json            # 项目配置文件
├── tsconfig.json           # TypeScript配置文件
├── tsconfig.node.json      # Node环境TypeScript配置
└── vite.config.ts          # Vite配置文件
```

## 目录说明

- **doc/**：存放项目相关文档，包括项目介绍、技术特点、目录结构和使用说明
- **src/**：存放项目源代码
  - **assets/**：存放静态资源，如图片、字体等
    - **images/**：存放所有图片资源，均使用SVG格式
  - **styles/**：存放样式文件，使用Less预处理器
  - **App.vue**：Vue应用的根组件，包含整个页面的结构
  - **main.ts**：Vue应用的入口文件，负责初始化和挂载应用
  - **vite-env.d.ts**：Vite环境的类型声明文件，包括SVG模块的类型声明
- **index.html**：HTML入口文件，引入了Vue应用
- **package.json**：项目配置文件，包含项目依赖、脚本命令等
- **tsconfig.json**：TypeScript配置文件，定义了编译选项
- **tsconfig.node.json**：Node环境下的TypeScript配置
- **vite.config.ts**：Vite构建工具的配置文件，包含资源内联限制、基础路径等配置

## 文件作用说明

1. **App.vue**：根组件，实现了整个网站的页面结构和交互逻辑
2. **main.ts**：应用入口，创建Vue实例并挂载到DOM
3. **vite-env.d.ts**：为Vite环境和SVG模块提供类型声明
4. **vite.config.ts**：配置Vite构建工具，包括资源内联限制、基础路径等
5. **package.json**：管理项目依赖和脚本命令
6. **src/assets/images/**：存放所有SVG图片资源，用于网站的各种图标和插图
7. **doc/**：存放项目文档，便于开发者理解和使用项目

## 目录结构特点

1. **清晰的模块化结构**：源代码与文档分离，便于管理和维护
2. **资源集中管理**：所有图片资源集中存放在assets/images目录下
3. **类型安全**：使用TypeScript确保代码类型安全
4. **构建配置优化**：Vite配置优化了资源打包和构建过程
5. **文档完整**：包含项目介绍、技术特点、目录结构和使用说明

这种目录结构设计遵循了现代前端项目的最佳实践，便于团队协作和项目扩展。