# 使用说明

## 1. 环境要求

在使用本项目前，请确保您的开发环境满足以下要求：

| 环境/工具 | 版本要求 | 用途 |
|-----------|----------|------|
| Node.js   | v16.0.0 或更高 | 运行JavaScript代码 |
| npm       | v8.0.0 或更高 | 包管理工具 |
| 浏览器     | Chrome、Firefox、Safari、Edge 最新版本 | 预览和测试网页 |

## 2. 安装步骤

### 2.1 克隆或下载项目

将项目文件下载到本地，确保项目文件完整。

### 2.2 安装依赖

打开命令行工具，进入项目根目录（k1669），执行以下命令安装项目依赖：

```bash
npm install
```

### 2.3 启动开发服务器

依赖安装完成后，执行以下命令启动开发服务器：

```bash
npm run dev
```

启动成功后，命令行会显示本地开发服务器的访问地址，通常为：

```
http://localhost:5173
```

在浏览器中输入该地址，即可预览项目。

## 3. 开发和调试

### 3.1 修改代码

使用您喜欢的代码编辑器（如VS Code、WebStorm等）打开项目，修改相关文件：

- 修改页面结构：编辑 `src/App.vue`
- 修改样式：编辑 `src/App.vue` 中的 `<style>` 部分或 `src/styles/main.less`
- 修改图片资源：替换 `src/assets/images/` 目录下的SVG文件
- 修改配置：编辑相关配置文件（如 `vite.config.ts`、`tsconfig.json` 等）

### 3.2 热更新

开发服务器支持热更新，当您修改代码并保存后，浏览器会自动刷新，无需手动刷新页面。

## 4. 构建项目

当开发完成后，需要将项目构建为生产版本，执行以下命令：

```bash
npm run build
```

构建完成后，生成的静态文件会存放在项目根目录下的 `dist` 目录中。

## 5. 预览构建结果

您可以使用Vite提供的预览命令，在本地预览构建后的项目：

```bash
npm run preview
```

预览成功后，命令行会显示预览服务器的访问地址，通常为：

```
http://localhost:4173
```

在浏览器中输入该地址，即可预览构建后的项目。

## 6. 部署项目

### 6.1 部署准备

构建完成后，`dist` 目录中的文件即为可部署的静态资源，包括：

- HTML文件（index.html）
- CSS文件（assets目录下）
- JavaScript文件（assets目录下）
- SVG图片文件（assets目录下）

### 6.2 部署方式

您可以将 `dist` 目录中的所有文件部署到任何静态文件服务器上，如：

- Nginx
- Apache
- GitHub Pages
- Netlify
- Vercel

部署时请注意：

- 确保服务器支持静态文件访问
- 无需特殊的服务器配置，直接部署静态文件即可
- 由于项目配置了 `base: './'`，支持相对路径部署，无需配置域名

## 7. 代码规范

### 7.1 命名规范

- 文件名：使用小写字母，多个单词之间用连字符（-）分隔
- 组件名：使用帕斯卡命名法（PascalCase）
- 变量名：使用驼峰命名法（camelCase）
- 常量名：使用全大写，多个单词之间用下划线（_）分隔

### 7.2 注释规范

- 文件头部添加文档注释，包括作者、链接、描述等
- 复杂代码添加单行注释或多行注释
- 使用文档注释格式，便于生成API文档

### 7.3 样式规范

- 使用Less预处理器编写样式
- 采用BEM命名规范或嵌套规则
- 避免使用!important
- 合理使用变量和混合

## 8. 常见问题及解决方案

### 8.1 安装依赖失败

**问题**：执行 `npm install` 时失败

**解决方案**：
- 检查Node.js和npm版本是否满足要求
- 清理npm缓存：`npm cache clean --force`
- 使用国内镜像源：`npm install --registry=https://registry.npmmirror.com`

### 8.2 开发服务器启动失败

**问题**：执行 `npm run dev` 时失败

**解决方案**：
- 检查端口是否被占用，尝试修改Vite配置中的端口号
- 检查项目文件是否完整，特别是配置文件

### 8.3 构建失败

**问题**：执行 `npm run build` 时失败

**解决方案**：
- 检查TypeScript类型错误：`npx tsc --noEmit`
- 检查代码中是否有语法错误
- 检查资源文件是否存在

### 8.4 页面显示异常

**问题**：浏览器中页面显示异常

**解决方案**：
- 检查浏览器控制台是否有错误信息
- 检查网络请求是否正常
- 检查CSS样式是否冲突
- 检查JavaScript代码是否有错误

## 9. 技术支持

如果您在使用过程中遇到问题，或需要技术支持，可以通过以下方式联系我们：

- 访问网站：[https://www.vsqdc.cn](https://www.vsqdc.cn)

## 10. 版本历史

- v1.0.0：初始版本，包含完整的企业形象展示网页功能

## 11. 版权信息

本项目由前端川开发，版权所有。

前端川 | [https://www.vsqdc.cn](https://www.vsqdc.cn)