import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'

// https://vite.dev/config/
export default defineConfig({
  plugins: [vue()],
  // 配置资源内联限制为2KB
  assetsInlineLimit: 2048,
  // 配置打包后的基础路径
  base: './',
  // 配置构建输出目录
  build: {
    outDir: 'dist',
    // 配置静态资源输出目录
    assetsDir: 'assets'
  }
})