# 学生学习导航站目录结构

## 项目根目录
```
e1686/
├── css/                    # CSS样式文件目录
│   └── style.css           # 主样式文件，包含所有页面样式
├── js/                     # JavaScript文件目录
│   └── script.js           # 主JavaScript文件，包含所有交互功能
├── img/                    # 图片资源目录，所有图片均为SVG格式
│   ├── logo.svg            # 网站Logo
│   ├── banner-pattern.svg  # 横幅背景图案
│   ├── online-courses.svg  # 在线课程分类图标
│   ├── e-books.svg         # 电子书籍分类图标
│   ├── study-tools.svg     # 学习工具分类图标
│   ├── practice-tests.svg  # 练习测试分类图标
│   ├── study-groups.svg    # 学习小组分类图标
│   ├── academic-papers.svg # 学术论文分类图标
│   ├── course1.svg         # 高等数学课程图标
│   ├── course2.svg         # 大学英语课程图标
│   ├── course3.svg         # 计算机基础课程图标
│   ├── course4.svg         # 大学物理课程图标
│   ├── course5.svg         # 有机化学课程图标
│   ├── course6.svg         # Python编程课程图标
│   ├── ebook1.svg          # 高等数学教材电子书封面
│   ├── ebook2.svg          # 大学英语词汇电子书封面
│   ├── note-taking.svg     # 笔记工具分类图标
│   ├── reference-manager.svg # 文献管理分类图标
│   ├── study-planner.svg   # 学习规划分类图标
│   ├── calculators.svg     # 计算器分类图标
│   ├── translation.svg     # 翻译工具分类图标
│   ├── collaboration.svg   # 协作工具分类图标
│   ├── tool1.svg           # 印象笔记工具图标
│   ├── tool2.svg           # Notion工具图标
│   ├── tool3.svg           # EndNote工具图标
│   ├── tool4.svg           # Zotero工具图标
│   ├── user-avatar.svg     # 用户头像图标
│   ├── math-group.svg      # 数学学习小组图标
│   ├── english-group.svg   # 英语学习小组图标
│   ├── computer-group.svg  # 计算机学习小组图标
│   ├── about-us.svg        # 关于我们页面主图片
│   ├── team-member1.svg    # 团队成员1头像
│   ├── team-member2.svg    # 团队成员2头像
│   ├── team-member3.svg    # 团队成员3头像
│   ├── team-member4.svg    # 团队成员4头像
│   ├── wechat.svg          # 微信社交媒体图标
│   ├── weibo.svg           # 微博社交媒体图标
│   ├── github.svg          # GitHub社交媒体图标
│   └── linkedin.svg        # LinkedIn社交媒体图标
├── doc/                    # 文档目录
│   ├── projIntro.md        # 项目详细介绍
│   ├── techFeat.md         # 技术特点
│   ├── dirStru.md          # 目录结构
│   └── userInstr.md        # 使用说明
├── index.html              # 首页
├── courses.html            # 课程资源页面
├── tools.html              # 学习工具页面
├── community.html          # 学习社区页面
└── about.html              # 关于我们页面
```

## 目录说明

### css/
存放项目的CSS样式文件，所有页面共享一个主样式文件`style.css`，包含了响应式设计、动画效果和现代化UI样式。

### js/
存放项目的JavaScript文件，所有页面共享一个主JavaScript文件`script.js`，包含了交互功能、滚动动画、移动端菜单等功能。

### img/
存放项目的所有图片资源，全部采用SVG格式，包括：
- 网站Logo和背景图案
- 分类图标（课程、工具、社区等）
- 课程图标和电子书封面
- 工具图标和团队成员头像
- 社交媒体图标

### doc/
存放项目的文档文件，包括：
- `projIntro.md`：项目详细介绍，包括项目概述、背景、核心功能等
- `techFeat.md`：技术特点，包括技术栈、架构设计、核心技术特点等
- `dirStru.md`：目录结构，以树形结构呈现项目目录，并附带注释说明
- `userInstr.md`：使用说明，包括环境要求、安装步骤等

### 页面文件
- `index.html`：网站首页，展示网站的主要功能和资源分类
- `courses.html`：课程资源页面，展示各类学科的在线课程、电子书籍和练习测试
- `tools.html`：学习工具页面，推荐和介绍各类学习工具
- `community.html`：学习社区页面，提供讨论、学习小组和资源分享功能
- `about.html`：关于我们页面，介绍平台的使命、愿景、团队成员等

## 设计思路

1. **模块化设计**：将CSS、JS和图片资源分离，便于维护和扩展
2. **资源集中管理**：所有资源均存放在相应的目录中，结构清晰
3. **响应式设计**：适配不同屏幕尺寸，提供良好的跨设备体验
4. **本地资源优先**：所有资源均为本地资源，不依赖外部CDN，提高加载速度和可靠性
5. **文档完整性**：提供详细的项目文档，便于其他开发者理解和使用

## 扩展建议

1. **添加新页面**：在根目录下添加新的HTML文件，并在导航栏中添加相应链接
2. **新增资源**：将新的CSS、JS或图片资源添加到对应的目录中
3. **修改样式**：在`style.css`中添加或修改样式，保持样式的一致性
4. **扩展功能**：在`script.js`中添加新的JavaScript功能
5. **更新文档**：及时更新相关文档，确保文档与代码的一致性