# 学生学习导航站使用说明

## 环境要求

### 浏览器要求
- **Chrome**: 最新版本
- **Firefox**: 最新版本
- **Safari**: 最新版本
- **Edge**: 最新版本

### 本地服务器要求（可选）
- 如需本地部署，建议使用以下任一方式：
  - Node.js + http-server
  - Python + http.server
  - Apache/Nginx 服务器
  - VS Code + Live Server 扩展

## 安装步骤

### 1. 获取项目文件

#### 方法一：直接下载
1. 从项目源码地址下载完整的项目压缩包
2. 解压到本地任意目录

#### 方法二：克隆项目（如果使用Git）
```bash
git clone <项目仓库地址>
```

### 2. 本地部署

#### 方式一：直接打开
1. 在文件管理器中找到项目目录
2. 双击 `index.html` 文件
3. 浏览器会自动打开网站首页

#### 方式二：使用本地服务器

##### 使用 Node.js http-server
1. 确保已安装 Node.js
2. 全局安装 http-server：
   ```bash
   npm install -g http-server
   ```
3. 进入项目目录：
   ```bash
   cd <项目目录>
   ```
4. 启动本地服务器：
   ```bash
   http-server -p 8080
   ```
5. 在浏览器中访问：`http://localhost:8080`

##### 使用 Python http.server
1. 确保已安装 Python
2. 进入项目目录：
   ```bash
   cd <项目目录>
   ```
3. 启动本地服务器：
   - Python 3：
     ```bash
     python -m http.server 8080
     ```
   - Python 2：
     ```bash
     python -m SimpleHTTPServer 8080
     ```
4. 在浏览器中访问：`http://localhost:8080`

##### 使用 VS Code Live Server 扩展
1. 安装 VS Code
2. 安装 Live Server 扩展
3. 用 VS Code 打开项目目录
4. 点击右下角的 "Go Live" 按钮
5. 浏览器会自动打开网站首页

## 项目使用

### 浏览页面

1. **首页**：展示网站的主要功能和资源分类
2. **课程资源**：浏览各类学科的在线课程、电子书籍和练习测试
3. **学习工具**：查看和使用各类学习工具
4. **学习社区**：参与讨论、加入学习小组、分享资源
5. **关于我们**：了解平台的使命、愿景和团队成员

### 使用功能

#### 导航菜单
- **PC端**：直接点击导航栏中的链接
- **移动端**：点击右上角的菜单按钮，展开导航菜单

#### 搜索功能
1. 在导航栏的搜索框中输入关键词
2. 点击搜索按钮或按下回车键
3. 查看搜索结果（当前为模拟搜索）

#### 资源分类
1. 在首页或课程资源页面浏览资源分类
2. 点击分类卡片查看相关资源
3. 点击 "查看更多" 链接进入详细页面

#### 学习社区
1. 浏览热门讨论帖子
2. 点击 "参与讨论" 按钮发表评论
3. 加入感兴趣的学习小组
4. 分享学习资源

### 响应式设计

- **PC端**：多列布局，充分利用屏幕空间
- **平板**：适当调整布局，保持良好的可读性
- **移动端**：单列布局，优化触摸交互

## 自定义和扩展

### 修改内容

#### 修改页面内容
1. 打开对应的 HTML 文件（如 `index.html`、`courses.html` 等）
2. 修改相应的 HTML 内容
3. 保存文件，刷新浏览器查看效果

#### 修改样式
1. 打开 `css/style.css` 文件
2. 修改或添加 CSS 样式
3. 保存文件，刷新浏览器查看效果

#### 修改交互功能
1. 打开 `js/script.js` 文件
2. 修改或添加 JavaScript 代码
3. 保存文件，刷新浏览器查看效果

### 添加新页面

1. 复制现有页面文件（如 `index.html`）
2. 重命名为新页面名称（如 `new-page.html`）
3. 修改页面内容和标题
4. 在导航栏中添加新页面链接

### 添加新资源

1. 将新的 SVG 图片添加到 `img/` 目录
2. 在 HTML 文件中引用新图片
3. 在 CSS 或 JS 中添加相应的样式和功能

## 常见问题和解决方案

### 问题1：页面无法正常显示
**解决方案**：
- 检查浏览器是否为最新版本
- 确保所有资源文件路径正确
- 尝试清除浏览器缓存

### 问题2：JavaScript 功能不生效
**解决方案**：
- 打开浏览器开发者工具（按 F12）
- 查看控制台是否有错误信息
- 检查 JavaScript 代码是否有语法错误

### 问题3：本地服务器无法启动
**解决方案**：
- 检查端口是否被占用
- 确保已正确安装所需的依赖
- 尝试使用不同的本地服务器方式

### 问题4：响应式设计在某些设备上显示异常
**解决方案**：
- 检查媒体查询断点设置
- 确保使用了正确的视口设置
- 测试不同浏览器和设备

## 更新日志

### 版本 1.0.0
- 初始版本发布
- 实现了基本的页面结构和功能
- 添加了响应式设计
- 实现了交互功能和动画效果

## 技术支持

如果您在使用过程中遇到问题，可以通过以下方式获取支持：
- 查看项目文档
- 检查浏览器控制台的错误信息
- 联系项目维护团队

## 许可证

本项目采用 [MIT License](LICENSE) 开源协议。

## 贡献指南

欢迎您为项目做出贡献：
1. Fork 项目仓库
2. 创建新的分支
3. 提交您的修改
4. 发起 Pull Request

## 版权声明

本项目所有内容仅供学习和参考使用，未经授权不得用于商业用途。

---

感谢您使用学生学习导航站！如有任何建议或反馈，欢迎随时联系我们。