# 目录结构

```
d1671/                    # 项目根目录
├── doc/                  # 文档目录
│   ├── projIntro.md      # 项目详细介绍
│   ├── techFeat.md       # 技术特点说明
│   ├── dirStru.md        # 目录结构说明
│   └── userInstr.md      # 使用说明
├── src/                  # 源代码目录
│   ├── assets/           # 静态资源目录
│   │   └── images/       # 图片资源目录，存放所有SVG图片
│   │       ├── logo.svg           # 网站Logo
│   │       ├── about.svg          # 关于我图片
│   │       ├── email.svg          # 邮箱图标
│   │       ├── phone.svg          # 电话图标
│   │       ├── location.svg       # 位置图标
│   │       ├── social1.svg        # 社交媒体图标1
│   │       ├── social2.svg        # 社交媒体图标2
│   │       ├── social3.svg        # 社交媒体图标3
│   │       ├── work1.svg          # 作品图片1
│   │       ├── work2.svg          # 作品图片2
│   │       ├── work3.svg          # 作品图片3
│   │       ├── work4.svg          # 作品图片4
│   │       ├── work5.svg          # 作品图片5
│   │       ├── work6.svg          # 作品图片6
│   │       └── hero-pattern.svg   # 英雄区域背景图案
│   ├── components/       # 组件目录，用于存放Vue组件
│   ├── styles/           # 样式目录
│   │   └── main.less     # 全局样式文件，包含样式重置和变量定义
│   ├── types/            # 类型定义目录，用于存放TypeScript类型定义
│   ├── App.vue           # 应用根组件，包含整个页面布局
│   ├── main.ts           # 应用入口文件，负责初始化Vue应用
│   └── vite-env.d.ts     # Vite环境类型声明，包含SVG模块类型定义
├── index.html            # HTML入口文件，定义页面结构和元信息
├── package.json          # 项目配置文件，包含依赖和脚本命令
├── tsconfig.json         # TypeScript配置文件，设置编译选项
├── tsconfig.node.json    # TypeScript Node配置文件，用于Vite工具
└── vite.config.ts        # Vite配置文件，设置构建选项和插件
```

## 目录说明

### 根目录 (d1671/)
项目的主目录，包含所有项目文件和子目录。

### 文档目录 (doc/)
存放项目相关文档，包括项目介绍、技术特点、目录结构和使用说明。

### 源代码目录 (src/)
存放项目的源代码，包括组件、样式、资源和入口文件。

#### 静态资源目录 (assets/)
存放项目所需的静态资源，如图片、字体等。

##### 图片资源目录 (images/)
存放项目中使用的所有SVG图片资源，包括Logo、图标、作品图片和背景图案。

#### 组件目录 (components/)
用于存放Vue组件，便于组件化开发和代码复用。

#### 样式目录 (styles/)
存放项目的样式文件，使用Less预处理器编写，包含全局样式和变量定义。

#### 类型定义目录 (types/)
存放TypeScript类型定义文件，用于增强代码的类型安全性。

### 配置文件
- **package.json**：管理项目依赖和脚本命令
- **tsconfig.json**：设置TypeScript编译选项
- **tsconfig.node.json**：为Vite工具提供TypeScript配置
- **vite.config.ts**：配置Vite构建选项，如基础路径、资源内联限制等

### 入口文件
- **index.html**：HTML入口文件，定义页面的基本结构和元信息
- **src/main.ts**：Vue应用的入口文件，负责创建和挂载Vue应用实例
- **src/App.vue**：Vue应用的根组件，包含整个页面的布局结构