# 技术特点

## 技术栈

| 技术 | 版本 | 用途 |
|------|------|------|
| Vue.js | 3.5.13 | 前端框架，用于构建用户界面 |
| TypeScript | ~5.6.2 | 类型安全的JavaScript超集，增强代码可维护性 |
| Vite | ^6.0.5 | 现代化前端构建工具，提供快速的开发体验和优化的构建输出 |
| Less | ^4.2.2 | CSS预处理器，用于编写模块化、可维护的样式代码 |

## 核心技术特点

### 1. Vue3组合式API

- 采用`script setup`语法糖，简化组件编写
- 使用`ref`、`computed`等响应式API，实现更灵活的状态管理
- 支持逻辑复用，提高代码可维护性和复用性
- 更好的TypeScript支持，提供完整的类型推导

### 2. TypeScript类型安全

- 全面的类型定义，确保代码的类型安全
- 自定义模块声明，支持SVG等资源的类型导入
- 严格的编译选项，提前发现潜在问题
- 增强代码的可读性和可维护性，便于团队协作

### 3. Vite构建优化

- 配置`base: './'`，确保打包后资源正确加载
- 调整`assetsInlineLimit`为2KB，优化资源加载策略
- 生成优化的构建输出，提高页面加载速度
- 支持热模块替换，提供快速的开发体验

### 4. 响应式设计

- 使用CSS Grid和Flexbox实现自适应布局
- 媒体查询适配不同屏幕尺寸
- 移动端友好的导航设计，支持汉堡菜单
- 图片和内容自适应缩放，确保在各种设备上的良好显示

### 5. 现代CSS特性

- CSS变量（Less变量）实现主题定制
- 渐变背景和阴影效果，增强视觉层次感
- 过渡和动画效果，提升用户体验
- 自定义滚动条样式，优化细节体验

### 6. 模块化结构

- 清晰的文件目录结构，便于代码组织和管理
- 组件化开发，提高代码复用性
- 样式分离，使用Less预处理器增强样式功能
- 资源集中管理，便于维护和更新

## 实现细节

### 1. SVG资源管理

- 所有图片资源使用SVG格式，保证高清显示和小文件体积
- 使用TypeScript模块声明，支持SVG资源的类型导入
- Vite配置确保SVG文件被正确打包，避免Base64内联过大的资源
- 统一的资源导入方式，便于管理和维护

### 2. 性能优化

- 组件懒加载，减少初始加载时间
- 资源按需加载，优化页面性能
- 平滑滚动实现，提升用户体验
- 优化的CSS选择器，提高样式渲染效率

### 3. 代码规范

- 严格的TypeScript类型检查
- 清晰的代码注释，便于理解和维护
- 统一的代码风格，提高代码可读性
- 模块化设计，便于扩展和更新

### 4. 构建配置

- 配置Vite构建选项，确保输出优化的静态资源
- CSS、JS和图片资源统一打包到assets文件夹
- 生成source map，便于调试
- 支持生产环境优化，如代码压缩、tree shaking等