# 使用说明

## 环境要求

- **Node.js**：建议使用LTS版本（v18.x或更高）
- **npm**：Node.js包管理器，通常随Node.js一起安装
- **Git**：版本控制系统（可选，用于克隆项目）

## 安装步骤

### 1. 克隆或下载项目

如果项目托管在Git仓库中，可以使用以下命令克隆项目：

```bash
git clone <repository-url>
cd d1671
```

如果是直接下载的项目压缩包，解压后进入项目目录：

```bash
cd d1671
```

### 2. 安装依赖

使用npm安装项目依赖：

```bash
npm install
```

## 开发流程

### 1. 启动开发服务器

运行以下命令启动Vite开发服务器：

```bash
npm run dev
```

开发服务器启动后，会在终端显示访问URL（通常是`http://localhost:5173`）。在浏览器中打开该URL即可查看项目效果。

### 2. 开发模式特性

- **热模块替换**：修改代码后，浏览器会自动刷新，无需手动刷新页面
- **类型检查**：实时进行TypeScript类型检查，发现潜在问题
- **错误提示**：在浏览器和终端中显示详细的错误信息，便于调试

### 3. 代码修改

- 修改组件：编辑`src/App.vue`或`src/components/`目录下的组件文件
- 修改样式：编辑`src/styles/main.less`文件
- 添加资源：将新的SVG图片放入`src/assets/images/`目录
- 修改配置：根据需要调整`vite.config.ts`、`tsconfig.json`等配置文件

## 构建部署

### 1. 类型检查

在构建前，建议先运行TypeScript类型检查，确保代码类型安全：

```bash
npm run type-check
```

### 2. 构建项目

运行以下命令构建生产版本：

```bash
npm run build
```

构建完成后，生成的静态文件会存放在`dist/`目录中。

### 3. 构建输出

构建输出的`dist/`目录结构如下：

```
dist/
├── assets/           # 打包后的资源文件
│   ├── [name]-[hash].js    # JavaScript文件
│   ├── [name]-[hash].css   # CSS文件
│   └── [name]-[hash].svg   # SVG图片文件
└── index.html        # 入口HTML文件
```

### 4. 部署

将`dist/`目录下的所有文件部署到Web服务器或静态网站托管服务即可。

## 项目配置

### Vite配置

主要配置项位于`vite.config.ts`文件中：

- `base: './'`：设置基础路径为相对路径，确保打包后资源正确加载
- `assetsInlineLimit: 2048`：设置资源内联限制为2KB，小于该大小的资源会被内联为Base64
- `build.outDir: 'dist'`：指定构建输出目录
- `build.assetsDir: 'assets'`：指定资源输出目录

### TypeScript配置

主要配置项位于`tsconfig.json`文件中：

- `strict: true`：启用严格模式
- `noUnusedLocals: true`：禁止未使用的局部变量
- `noUnusedParameters: true`：禁止未使用的参数
- `noFallthroughCasesInSwitch: true`：禁止switch语句中的fallthrough情况

## 代码规范

- 使用TypeScript编写所有代码，确保类型安全
- 组件使用`script setup`语法糖
- 样式使用Less预处理器，遵循BEM命名规范
- 代码中添加清晰的注释，便于理解和维护
- 遵循ESLint和Prettier规范（如果项目中配置了这些工具）

## 常见问题

### 1. 依赖安装失败

- 确保Node.js版本符合要求
- 尝试清除npm缓存：`npm cache clean --force`
- 尝试使用国内镜像：`npm config set registry https://registry.npmmirror.com`

### 2. 构建失败

- 检查TypeScript类型错误：`npm run type-check`
- 检查代码语法错误
- 检查资源文件路径是否正确

### 3. 部署后资源加载失败

- 确保Vite配置中的`base`设置正确
- 检查HTML文件中资源引用路径是否正确
- 确保服务器配置正确，支持相对路径访问

## 联系信息

如果在使用过程中遇到问题，或有任何建议和反馈，可以通过以下方式联系：

- 前端川
- 网址：https://www.vsqdc.cn