import { defineConfig } from 'vite';
import vue from '@vitejs/plugin-vue';
// https://vite.dev/config/
export default defineConfig({
    // 设置基础路径为相对路径，确保打包后资源可以正确加载
    base: './',
    plugins: [vue()],
    // 配置Less预处理器
    css: {
        preprocessorOptions: {
            less: {
                math: 'always',
                relativeUrls: true,
                javascriptEnabled: true
            }
        }
    },
    // 配置构建输出目录和资源命名
    build: {
        outDir: 'dist',
        assetsDir: 'assets',
        // 配置资源内联限制为2KB
        assetsInlineLimit: 2048,
        rollupOptions: {
            output: {
                // 配置资源打包后的命名规则
                assetFileNames: 'assets/[name]-[hash][extname]',
                chunkFileNames: 'assets/[name]-[hash].js',
                entryFileNames: 'assets/[name]-[hash].js'
            }
        }
    }
});
