# 创意导航 - 目录结构

## 项目目录树

```
n1684/
├── css/                    # CSS样式文件目录
│   └── style.css           # 主样式文件，包含所有页面样式和响应式设计
├── js/                     # JavaScript文件目录
│   └── main.js             # 主JavaScript文件，实现交互功能
├── img/                    # 图片资源目录
│   ├── logo.svg            # 网站Logo
│   ├── menu.svg            # 移动端菜单图标
│   ├── close.svg           # 关闭按钮图标
│   ├── search.svg          # 搜索图标
│   ├── hero-bg.svg         # 英雄区域背景图
│   ├── category-design.svg # 设计分类图标
│   ├── category-dev.svg    # 开发分类图标
│   ├── category-tools.svg  # 创意工具分类图标
│   ├── category-ui.svg     # UI设计分类图标
│   ├── category-illustration.svg # 插画分类图标
│   ├── category-frontend.svg # 前端开发分类图标
│   ├── resource-1.svg      # 资源卡片图标（Figma）
│   ├── resource-2.svg      # 资源卡片图标（VS Code）
│   ├── resource-3.svg      # 资源卡片图标（Canva）
│   ├── resource-4.svg      # 资源卡片图标（GitHub）
│   ├── resource-vscode.svg # VS Code资源图标
│   ├── resource-react.svg  # React资源图标
│   ├── resource-vue.svg    # Vue.js资源图标
│   ├── recommendation-1.svg # 推荐卡片图片1
│   ├── recommendation-2.svg # 推荐卡片图片2
│   ├── recommendation-3.svg # 推荐卡片图片3
│   ├── feature-quality.svg # 特性图标（精选资源）
│   ├── feature-categories.svg # 特性图标（分类清晰）
│   ├── feature-responsive.svg # 特性图标（响应式设计）
│   ├── feature-update.svg  # 特性图标（定期更新）
│   ├── contact-email.svg   # 联系图标（邮箱）
│   ├── contact-wechat.svg  # 联系图标（微信）
│   └── contact-website.svg # 联系图标（网站）
├── doc/                    # 文档目录
│   ├── projIntro.md        # 项目详细介绍
│   ├── techFeat.md         # 技术特点
│   ├── dirStru.md          # 目录结构（当前文件）
│   └── userInstr.md        # 使用说明
├── index.html              # 首页
├── design.html             # 设计分类页面
├── development.html        # 开发分类页面
├── tools.html              # 创意工具分类页面
└── about.html              # 关于页面
```

## 目录说明

### 1. 根目录 (n1684/)

项目的主目录，包含所有网站文件和子目录。

### 2. css/ 目录

存放网站的CSS样式文件，包含所有页面的样式定义、响应式设计和视觉效果。

- **style.css**：主样式文件，包含所有页面的样式定义，包括导航栏、英雄区域、资源卡片、页脚等组件的样式，以及响应式设计规则。

### 3. js/ 目录

存放网站的JavaScript文件，实现交互功能和动态效果。

- **main.js**：主JavaScript文件，实现移动端菜单、搜索功能、平滑滚动、卡片动画等交互效果。

### 4. img/ 目录

存放网站使用的所有SVG图片资源，包括图标、背景图和装饰性元素。

- **logo.svg**：网站的Logo，位于页面顶部导航栏
- **menu.svg**：移动端菜单按钮图标
- **close.svg**：关闭按钮图标
- **search.svg**：搜索框图标
- **hero-bg.svg**：首页英雄区域的背景图
- **category-*.svg**：各类分类的图标，用于分类导航
- **resource-*.svg**：资源卡片中使用的图标
- **recommendation-*.svg**：推荐卡片中使用的图片
- **feature-*.svg**：关于页面中特性介绍的图标
- **contact-*.svg**：关于页面中联系信息的图标

### 5. doc/ 目录

存放项目的文档文件，包含项目介绍、技术特点、目录结构和使用说明。

- **projIntro.md**：项目详细介绍，包括项目定位、核心功能、目标用户等
- **techFeat.md**：技术特点，包含技术栈、核心技术实现等
- **dirStru.md**：目录结构说明，以树形结构展示项目文件组织
- **userInstr.md**：使用说明，包含环境要求、安装步骤等

### 6. HTML页面

- **index.html**：网站首页，包含英雄区域、分类导航、精选资源和热门推荐
- **design.html**：设计分类页面，展示设计相关资源
- **development.html**：开发分类页面，展示开发相关资源
- **tools.html**：创意工具分类页面，展示创意工具相关资源
- **about.html**：关于页面，介绍网站的使命、愿景和联系信息

## 目录设计原则

1. **清晰的分类**：按功能和类型组织文件，便于查找和管理
2. **模块化设计**：CSS和JavaScript按功能模块化，便于维护和扩展
3. **资源集中管理**：所有图片资源集中存放在img目录
4. **文档完整性**：包含详细的项目文档，便于团队协作和后续维护
5. **响应式设计**：所有页面都支持响应式布局，适配不同设备

## 文件命名规范

- HTML文件：使用小写字母，单词之间用连字符分隔（如：design.html）
- CSS和JavaScript文件：使用小写字母，主文件命名为style.css和main.js
- 图片文件：使用小写字母，描述性命名，后缀为.svg
- 文档文件：使用驼峰命名法，后缀为.md

## 代码组织规范

- **HTML**：使用语义化标签，清晰的结构层次
- **CSS**：使用CSS变量，模块化组织，响应式设计
- **JavaScript**：函数模块化，详细注释，清晰的代码结构
- **SVG**：优化的矢量图形，适合Web使用

## 资源管理

- 所有资源都存储在本地，不依赖外部资源
- 图片资源使用SVG格式，确保高质量和小文件大小
- 资源文件命名清晰，便于识别和使用

通过以上目录结构和命名规范，确保了项目的可维护性、可扩展性和可读性，便于团队协作和后续开发。