# 创意导航 - 使用说明

## 环境要求

### 1. 浏览器要求
- **Chrome**：版本 80 及以上
- **Firefox**：版本 75 及以上
- **Safari**：版本 13 及以上
- **Edge**：版本 80 及以上

### 2. 设备要求
- **PC端**：分辨率 1024x768 及以上
- **移动端**：支持 iOS 和 Android 设备，分辨率 320x568 及以上

### 3. 网络要求
- 无需特殊网络环境，可离线访问（所有资源均为本地资源）

## 安装步骤

### 1. 下载项目文件

将项目文件下载到本地计算机，确保所有文件结构完整。

### 2. 部署方式

#### 方式一：直接打开

1. 找到项目根目录下的 `index.html` 文件
2. 双击 `index.html` 文件，使用默认浏览器打开
3. 网站将在浏览器中运行

#### 方式二：本地服务器

对于需要使用本地服务器的情况（如使用某些API或需要跨域请求），可以使用以下方法：

##### 使用 Python 内置服务器

1. 打开命令行工具
2. 导航到项目根目录
3. 运行以下命令：
   ```bash
   # Python 3
   python -m http.server 8000
   
   # Python 2
   python -m SimpleHTTPServer 8000
   ```
4. 在浏览器中访问 `http://localhost:8000`

##### 使用 Node.js http-server

1. 确保已安装 Node.js
2. 安装 http-server：
   ```bash
   npm install -g http-server
   ```
3. 导航到项目根目录
4. 运行以下命令：
   ```bash
   http-server -p 8000
   ```
5. 在浏览器中访问 `http://localhost:8000`

## 使用说明

### 1. 浏览首页

- 打开网站后，首先看到的是首页
- 首页包含英雄区域、热门分类、精选资源和热门推荐
- 可以通过导航栏快速跳转到其他页面

### 2. 分类浏览

- 点击导航栏中的分类链接（设计、开发、创意工具）
- 或点击首页的分类图标
- 在分类页面中，可以浏览该分类下的所有资源
- 每个分类页面包含多个子分类，便于更精确地查找资源

### 3. 搜索资源

- 在导航栏或英雄区域的搜索框中输入关键词
- 按下回车键或点击搜索按钮
- 搜索结果将显示相关资源

### 4. 访问资源

- 找到需要的资源卡片
- 点击卡片上的"访问"按钮
- 或点击资源名称
- 将直接跳转到该资源的官方网站

### 5. 移动端使用

- 在移动设备上访问网站时，导航栏会隐藏
- 点击右上角的菜单按钮，显示侧边栏菜单
- 通过侧边栏菜单可以导航到其他页面
- 点击关闭按钮或遮罩层，关闭侧边栏菜单

## 维护说明

### 1. 更新资源

要更新或添加新资源：

1. 打开相应的HTML文件（如 `design.html`）
2. 在对应的分类区域中添加或修改资源卡片
3. 资源卡片的HTML结构示例：
   ```html
   <div class="resource-card">
       <div class="card-header">
           <img src="img/resource-example.svg" alt="资源名称">
           <h3>资源名称</h3>
       </div>
       <p>资源描述</p>
       <div class="card-footer">
           <span class="category-tag">分类标签</span>
           <a href="https://example.com" class="visit-btn">访问</a>
       </div>
   </div>
   ```

### 2. 添加新分类

要添加新的分类：

1. 在HTML文件中添加新的分类区域
2. 分类区域的HTML结构示例：
   ```html
   <div id="new-category" class="category-section">
       <h2>新分类名称</h2>
       <div class="resources-grid">
           <!-- 资源卡片 -->
       </div>
   </div>
   ```

### 3. 修改样式

要修改网站样式：

1. 打开 `css/style.css` 文件
2. 修改相应的CSS规则
3. 可以通过修改CSS变量来改变网站主题色：
   ```css
   :root {
       --primary-color: #6c5ce7;
       --secondary-color: #00cec9;
       /* 其他变量 */
   }
   ```

### 4. 更新JavaScript功能

要添加或修改交互功能：

1. 打开 `js/main.js` 文件
2. 添加或修改相应的JavaScript函数
3. 函数模块化，便于维护和扩展

## 常见问题

### 1. 网站无法正常显示

- 检查浏览器版本是否符合要求
- 确保所有文件结构完整，没有缺少必要文件
- 尝试清除浏览器缓存

### 2. 资源链接无法访问

- 检查资源链接是否正确
- 确认资源网站是否仍然可用
- 更新资源链接或替换为可用的资源

### 3. 移动端显示异常

- 检查浏览器是否支持响应式设计
- 确保设备分辨率符合要求
- 尝试刷新页面或清除缓存

## 技术支持

如果遇到其他问题或需要技术支持，请通过以下方式联系我们：

- 邮箱：contact@vsqdc.cn
- 微信：frontend-chuan
- 网站：[https://www.vsqdc.cn](https://www.vsqdc.cn)

## 版权信息

- 本项目由前端川开发
- 所有资源链接均指向第三方网站，版权归原作者所有
- 本项目仅用于学习和参考

创意导航网站使用简单，部署方便，适合作为创意资源导航平台使用。通过定期更新资源和优化用户体验，可以不断提升网站的价值和实用性。